/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

import java.io.Serializable;
import java.util.Objects;

import lombok.Data;

@Data
public class ValidationError implements Serializable {
    private static final long serialVersionUID = -6011003280346460581L;

    private final ValidationErrorTypeEnum errorType;
    private String messageRefId;
    private Integer errorCounter = 1;
    private String errorShortDesc;
    private String errorLongDesc;
    private String docRefId;
    private String transactionIdentifier;

    public ValidationError(ValidationErrorTypeEnum errorType) {
        this.errorType = Objects.requireNonNull(errorType);
        setErrorShortDesc(errorType.getDescription());
        setErrorLongDesc(errorType.getDescription()); // expected to be overwritten
    }

    public String getErrorCode() {
        return errorType.getCode();
    }

    public boolean isFullRejection() {
        return errorType.getResultType() == ValidationResultTypeEnum.FULLY_REJECTED;
    }
}
